/****** Object:  StoredProcedure [dbo].[P_MEDIAF_FALTA_CRONICA]    Script Date: 05/20/2013 17:10:48 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_MEDIAF_FALTA_CRONICA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_MEDIAF_FALTA_CRONICA]
GO
 
--VERIFICA SE O PRODUTO POSSUI 3 RECALCULOS DE MEDIA SEM MOVIMENTACAO E ESTOQUE
--EXECUTE P_MEDIAF_FALTA_CRONICA
/*
=======================================================================================
'Job.................: Job Media de Vendas 
'Funo..............: 
'Objetivo............:    
'Tabelas.............: 
'Dt Modificao......: 28/04/2021
'Modificao.........: Tag #A001 Zerar media P para produtos de falta cronica que no faz parte da analise de falta. 
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 
*/
CREATE PROCEDURE [dbo].[P_MEDIAF_FALTA_CRONICA] AS

BEGIN TRY

SET DEADLOCK_PRIORITY 9;

CREATE TABLE #PROD_FALTA_ANALISE(CD_EMP INT,CD_FILIAL INT,CD_PROD INT)
CREATE TABLE #PROD_FALTA_CRONICA(CD_EMP INT,CD_FILIAL INT,CD_PROD INT, QTDE_MEDIAF MONEY)
DECLARE @DT_REF AS DATETIME

	SET @DT_REF = CONVERT(VARCHAR, GETDATE(),112)

	--Retirando produto falta cronica mediaP
	--Quando tiver estoque
	UPDATE
		EST_PROD_CPL_MEDIAP
	SET 
		EST_PROD_CPL_MEDIAP.FALTA_CRONICA=0,
		EST_PROD_CPL_MEDIAP.CD_USU=1,
		EST_PROD_CPL_MEDIAP.DT_ULT_ALT= GETDATE()
	FROM
		EST_PROD_CPL  
		INNER JOIN EST_PROD_CPL_MEDIAP ON
		EST_PROD_CPL.CD_EMP = EST_PROD_CPL_MEDIAP.CD_EMP AND
		EST_PROD_CPL.CD_FILIAL = EST_PROD_CPL_MEDIAP.CD_FILIAL AND
		EST_PROD_CPL.CD_PROD = EST_PROD_CPL_MEDIAP.CD_PROD
		INNER JOIN EST_PROD_CPL_MEDIAF ON
		EST_PROD_CPL.CD_EMP = EST_PROD_CPL_MEDIAF.CD_EMP AND
		EST_PROD_CPL.CD_FILIAL = EST_PROD_CPL_MEDIAF.CD_FILIAL AND
		EST_PROD_CPL.CD_PROD = EST_PROD_CPL_MEDIAF.CD_PROD
		INNER JOIN EST_PROD ON 
		EST_PROD_CPL.CD_EMP = EST_PROD.CD_EMP AND		
		EST_PROD_CPL.CD_PROD = EST_PROD.CD_PROD
	WHERE
		EST_PROD_CPL.CD_EMP = 1
		AND (EST_PROD_CPL.QT_EST > 0 OR EST_PROD_CPL.STS_PROD IN (1,2) OR EST_PROD.FLAG_ANALISE_FALTAS = 1 
			--OR EST_PROD_CPL_MEDIAF.QTDE_MEDIAF=0
			)
		AND EST_PROD_CPL_MEDIAP.FALTA_CRONICA=1
		

-- Tag #A001		
	UPDATE
		EST_PROD_CPL_MEDIAP
	SET 
		EST_PROD_CPL_MEDIAP.FALTA_CRONICA=0,
		EST_PROD_CPL_MEDIAP.CD_USU=1,
		EST_PROD_CPL_MEDIAP.DT_ULT_ALT= GETDATE(),
		EST_PROD_CPL_MEDIAP.QTDE_MEDIAP=0
	FROM EST_PROD_CPL_MEDIAP  
		INNER JOIN EST_PROD ON EST_PROD_CPL_MEDIAP.CD_EMP  = EST_PROD.CD_EMP
						   AND EST_PROD_CPL_MEDIAP.CD_PROD = EST_PROD.CD_PROD
	WHERE
		EST_PROD_CPL_MEDIAP.CD_EMP = 1
		AND EST_PROD.FLAG_ANALISE_FALTAS = 1 
		AND EST_PROD_CPL_MEDIAP.FALTA_CRONICA=1
		AND EST_PROD_CPL_MEDIAP.QTDE_MEDIAP > 0 

/************************************************************************************************/
/************************************************************************************************/
 
	--ATUALIZANDO A TABELA SEM ESTOQUE

		DECLARE @cd_chave_FILIAL INT;

		DECLARE c_Chave CURSOR FAST_FORWARD
		FOR SELECT
				   CD_FILIAL
			FROM
				 PRC_FILIAL
			ORDER BY
					 CD_FILIAL;

		OPEN c_Chave;

		FETCH NEXT FROM c_Chave INTO @cd_chave_FILIAL;

		WHILE @@FETCH_STATUS = 0
			BEGIN
				PRINT 'Procesando lj '+CONVERT(VARCHAR, @cd_chave_FILIAL);

				DELETE FROM PROD
				FROM EST_PROD_CPL_SEM_ESTOQUE PROD
					 INNER JOIN EST_PROD_CPL S ON PROD.CD_EMP = S.CD_EMP
												  AND PROD.CD_FILIAL = S.CD_FILIAL
												  AND PROD.CD_PROD = S.CD_PROD
					 INNER JOIN EST_PROD ON S.CD_EMP = EST_PROD.CD_EMP
											AND S.CD_PROD = EST_PROD.CD_PROD
				WHERE
					  S.CD_EMP = 1
					  AND (S.QT_EST > 0
						   OR S.STS_PROD IN(1, 2)
						   OR EST_PROD.FLAG_ANALISE_FALTAS = 1)

					  AND s.cd_filial = @cd_chave_FILIAL;

				INSERT INTO EST_PROD_CPL_SEM_ESTOQUE(CD_EMP, CD_FILIAL, CD_PROD, DT_ESTOQUE_ZERADO)
				SELECT
						A.CD_EMP
					, A.CD_FILIAL
					, A.CD_PROD
					, GETDATE() DT_ESTOQUE_ZERADO
				FROM
					EST_PROD_CPL A
					LEFT OUTER JOIN EST_PROD_CPL_SEM_ESTOQUE B ON A.CD_EMP = B.CD_EMP
																	AND A.CD_FILIAL = B.CD_FILIAL
																	AND A.CD_PROD = B.CD_PROD
				WHERE A.CD_EMP = 1
						AND A.QT_EST < 1
						AND A.STS_PROD = 0
						AND A.cd_filial =@cd_chave_FILIAL
						AND B.CD_EMP IS NULL;

				FETCH NEXT FROM c_Chave INTO @cd_chave_FILIAL;
			END;

		CLOSE c_Chave; 
		DEALLOCATE c_Chave;
	 
/************************************************************************************************/
/************************************************************************************************/	
		

	INSERT INTO #PROD_FALTA_ANALISE
	SELECT     
		EST_PROD_CPL.CD_EMP, 
		EST_PROD_CPL.CD_FILIAL, 
		EST_PROD_CPL.CD_PROD 
	FROM         
		EST_PROD_CPL  
		INNER JOIN EST_PROD_CPL_SEM_ESTOQUE ON 
		EST_PROD_CPL.CD_EMP = EST_PROD_CPL_SEM_ESTOQUE.CD_EMP AND 
		EST_PROD_CPL.CD_FILIAL = EST_PROD_CPL_SEM_ESTOQUE.CD_FILIAL AND 
		EST_PROD_CPL.CD_PROD = EST_PROD_CPL_SEM_ESTOQUE.CD_PROD 
		
		INNER JOIN EST_PROD P ON 
		EST_PROD_CPL.CD_EMP  = P.CD_EMP AND 
		EST_PROD_CPL.CD_PROD = P.CD_PROD
	 
		INNER JOIN EST_PROD_CURVA_SIGLA ON 
		EST_PROD_CPL.CD_EMP = EST_PROD_CURVA_SIGLA.CD_EMP AND 
		EST_PROD_CPL.CD_SIGLA = EST_PROD_CURVA_SIGLA.CD_SIGLA
		
		INNER JOIN EST_PROD_CPL_NASC ON 
		EST_PROD_CPL.CD_EMP = EST_PROD_CPL_NASC.CD_EMP AND 
		EST_PROD_CPL.CD_FILIAL = EST_PROD_CPL_NASC.CD_FILIAL AND 
		EST_PROD_CPL.CD_PROD = EST_PROD_CPL_NASC.CD_PROD

		INNER JOIN PRC_FILIAL F ON 
		EST_PROD_CPL.CD_EMP = F.CD_EMP AND 
		EST_PROD_CPL.CD_FILIAL = F.CD_FILIAL 

	WHERE
		EST_PROD_CPL.CD_EMP=1     
		AND P.STS_PROD IN (0,2)
		AND EST_PROD_CPL.MEDIAF  > 0
		AND EST_PROD_CURVA_SIGLA.CTR_FALTA_CRONICA = 1
		AND EST_PROD_CPL_NASC.MEDIA_F_LIBERADA= 1 
		AND NOT EST_PROD_CPL.CD_FILIAL IN (SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO WHERE CD_EMP=1 )
		AND F.ESPECIE_FILIAL = 1
		AND ISNULL(P.FLAG_ANALISE_FALTAS,0) = 0;
		 

--SE HOUVER REGISTRO CONTINUA COM A TRANSACAO
IF EXISTS (SELECT * FROM #PROD_FALTA_ANALISE)
BEGIN
	--APAGANDO PRODUTOS QUE ESTAVAM EM FALTA CRONICA E NAO ESTAO NO 
	--LTIMO RECALCULO SEM VENDA E SEM ESTOQUE
	DELETE F
	FROM EST_PROD_CPL_FALTA_CRONICA F
		LEFT JOIN #PROD_FALTA_ANALISE PF ON 
		F.CD_EMP		= PF.CD_EMP AND
		F.CD_FILIAL		= PF.CD_FILIAL AND
		F.CD_PROD		= PF.CD_PROD
	WHERE PF.CD_EMP IS NULL;
						  
	--SE O PRODUTO JA EXISTIR ADICIONAR O NUMERO DE RECALCULO SEM ESTOQUE E VENDAS
	UPDATE 
		F
	SET
		QTDE_RECALCULO = QTDE_RECALCULO + 1,
		FREAV_ULT_ATU = @DT_REF,
		DT_ULT_ALT    = @DT_REF 
	FROM 
		#PROD_FALTA_ANALISE PF 
		INNER JOIN EST_PROD_CPL_FALTA_CRONICA F ON
		F.CD_EMP		= PF.CD_EMP AND
		F.CD_FILIAL		= PF.CD_FILIAL AND
		F.CD_PROD		= PF.CD_PROD
		INNER JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA m ON
		F.CD_EMP	= M.CD_EMP AND
		F.CD_FILIAL = M.CD_FILIAL AND
		F.CD_PROD	= M.CD_PROD 
	WHERE   ( (ISNULL(F.FREAV_ULT_ATU,@DT_REF) + M.FREAV_MEDIAF) <= @DT_REF);

	--INSERINDO PRIMEIRO CONTROLE DE FALTA CRONICA DO PRODUTO
	INSERT INTO EST_PROD_CPL_FALTA_CRONICA (CD_EMP,CD_FILIAL,CD_PROD,QTDE_RECALCULO,DT_CAD,FREAV_ULT_ATU)
	SELECT     
		PF.CD_EMP, 
		PF.CD_FILIAL, 
		PF.CD_PROD,
		1 QTDE_RECALCULO,
		GETDATE() DT_CAD,
		@DT_REF
	FROM 
		#PROD_FALTA_ANALISE PF
	WHERE NOT EXISTS(SELECT
						*
					FROM         
						EST_PROD_CPL_FALTA_CRONICA
					WHERE 
						EST_PROD_CPL_FALTA_CRONICA.CD_EMP		= PF.CD_EMP AND
						EST_PROD_CPL_FALTA_CRONICA.CD_FILIAL	= PF.CD_FILIAL AND
						EST_PROD_CPL_FALTA_CRONICA.CD_PROD		= PF.CD_PROD);

	--BUSCANDO OS PRODUTOS QUE ESTAO EM FALTA CRONICA DE ACORDO COM A QUANTIDADE DE RECALCULO
	--SE VALOR DE VENDA E SEM ESTOQUE
	INSERT INTO #PROD_FALTA_CRONICA
	SELECT     
		FA.CD_EMP, 
		FA.CD_FILIAL, 
		FA.CD_PROD, 
		F.QTDE_MEDIAF
	FROM         
		EST_PROD_CPL_FALTA_CRONICA FA 
		INNER JOIN EST_PROD_CPL_MEDIAF F ON 
		FA.CD_EMP = F.CD_EMP AND 
		FA.CD_FILIAL = F.CD_FILIAL AND 
		FA.CD_PROD = F.CD_PROD 
		INNER JOIN EST_PROD_CPL_NASC N ON 
		F.CD_EMP = N.CD_EMP AND 
		F.CD_FILIAL = N.CD_FILIAL AND 
		F.CD_PROD = N.CD_PROD
		INNER JOIN EST_ARV_MD_F_GRP_PARAM_CURVA_FALTA_CRONICA P ON
		F.CD_EMP = P.CD_EMP AND
		F.CD_SIGLA = P.CD_SIGLA AND
		FA.QTDE_RECALCULO >= P.QTDE_RECALCULO
	WHERE     
		N.MEDIA_F_LIBERADA = 1;
END

--SE EXISTIR REGISTRO ENTAO CONTINUA PROCESSO
IF EXISTS (SELECT * FROM #PROD_FALTA_CRONICA)
BEGIN
	--DELETANDO NASCIMENTO DO PRODUTO E AGUARDANDO RENASCIMENTO DO MESMO NA LOJA, OU SEJA,
	--PROXIMA PRIMEIRA ENTRADA.
	DELETE N 
	FROM EST_PROD_CPL_NASC  N
	WHERE EXISTS (SELECT 
						* 
				   FROM 
						#PROD_FALTA_CRONICA FALTA 
				   WHERE	
						N.CD_EMP = FALTA.CD_EMP AND
						N.CD_FILIAL = FALTA.CD_FILIAL AND
						N.CD_PROD = FALTA.CD_PROD);

	--CONGELANDO A MEDIA F NA MEDIA P PARA QUE O PRODUTO TENHA O PROCEDIMENTO DE 
	--PRODUTO DE LANCAMENTO NA LOJA
	--ATUALIZANDO PARA OS PRODUTOS QUE JA POSSUIRAM MEDIA P
	UPDATE 
		P
	SET
		P.QTDE_MEDIAP = FALTA.QTDE_MEDIAF,
		P.FALTA_CRONICA = 1,
		CD_USU= 1,
		P.DT_CAD=CONVERT(CHAR(10),GETDATE(),120),
		p.dt_ult_alt = getdate()
	FROM 
		#PROD_FALTA_CRONICA FALTA 
		INNER JOIN EST_PROD_CPL_MEDIAP P ON
		FALTA.CD_EMP = P.CD_EMP AND
		FALTA.CD_FILIAL = P.CD_FILIAL AND
		FALTA.CD_PROD = P.CD_PROD;

	--INSERINDO PARA OS PRODUTOS QUE NUNCA POSSUIRAM MEDIA P
	INSERT INTO	EST_PROD_CPL_MEDIAP
		(CD_EMP,
		CD_FILIAL,
		CD_PROD,
		QTDE_MEDIAP,
		FALTA_CRONICA,
		CD_USU,
		DT_CAD,
		DT_ULT_ALT)
	SELECT
		FALTA.CD_EMP,
		FALTA.CD_FILIAL,
		FALTA.CD_PROD,
		FALTA.QTDE_MEDIAF,
		1,
		1,
		CONVERT(CHAR(10),GETDATE(),120),
		NULL
	FROM
		#PROD_FALTA_CRONICA FALTA
	WHERE NOT EXISTS (SELECT 
							* 
					   FROM 
							EST_PROD_CPL_MEDIAP P 
					   WHERE	
							FALTA.CD_EMP = P.CD_EMP AND
							FALTA.CD_FILIAL = P.CD_FILIAL AND
							FALTA.CD_PROD = P.CD_PROD);	

	--ZERANDO MEDIA F DOS PRODUTOS
	UPDATE 
		F
	SET
		QTDE_MEDIAF = 0,
		CD_USU= 1,
		DT_CAD	=GETDATE(),
		DT_ULT_ALT=GETDATE()
	FROM 
		#PROD_FALTA_CRONICA FALTA 
		INNER JOIN EST_PROD_CPL_MEDIAF F ON
		FALTA.CD_EMP = F.CD_EMP AND
		FALTA.CD_FILIAL = F.CD_FILIAL AND
		FALTA.CD_PROD = F.CD_PROD;

	--DELETANDO PRODUTO QUE JA PASSARAM DO LIMITE DE RECALCULOS COM VALORES ZERADOS
	DELETE F
	FROM
		EST_PROD_CPL_FALTA_CRONICA F 
		INNER JOIN #PROD_FALTA_CRONICA C ON
		F.CD_EMP = C.CD_EMP AND
		F.CD_FILIAL = C.CD_FILIAL AND
		F.CD_PROD = C.CD_PROD;

END

DROP TABLE #PROD_FALTA_ANALISE;
DROP TABLE #PROD_FALTA_CRONICA;
 
END TRY 

BEGIN CATCH

   DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
   DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
   DECLARE @ErrorState INT = ERROR_STATE();

   INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
	  SELECT
		 ERROR_NUMBER()			AS numero
		 ,@ErrorSeverity		AS severidade
		 ,@ErrorState			AS estado
		 ,ERROR_PROCEDURE()		AS rotina
		 ,ERROR_LINE()			AS linha
		 ,@ErrorMessage			AS mensagem
		 ,GETDATE()				AS dtErro ;

   RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
END CATCH;